<?php
// /home/cryptob6/public_html/__domains/open360.net/fakturisanje/index.php

declare(strict_types=1);

// DEBUG (privremeno) - kad sve proradi, ugasi ili prebaci na 0
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

// Path to private app root
$APP_ROOT = '/home/cryptob6/fakturisanje';

// Safety check
if (!is_dir($APP_ROOT)) {
    http_response_code(500);
    header('Content-Type: text/plain; charset=utf-8');
    echo "App root not found: " . $APP_ROOT;
    exit;
}

// Simple autoloader for App\* classes inside /src
spl_autoload_register(function (string $class) use ($APP_ROOT): void {
    $prefix = 'App\\';
    if (!str_starts_with($class, $prefix)) {
        return;
    }

    $relative = substr($class, strlen($prefix));
    $file = $APP_ROOT . '/src/' . str_replace('\\', '/', $relative) . '.php';

    if (is_file($file)) {
        require $file;
    }
});

// Load Composer autoload for vendor libraries (mPDF, etc.)
require_once $APP_ROOT . '/vendor/autoload.php';

// Load config
$configFile = $APP_ROOT . '/config/app.php';
if (!is_file($configFile)) {
    http_response_code(500);
    header('Content-Type: text/plain; charset=utf-8');
    echo "Missing config/app.php";
    exit;
}

$config = require $configFile;

// Core objects
$router = new \App\Core\Router();
$app = new \App\Core\App($config, $router);

$appUrl = (string)($config['app']['url'] ?? '');
$view   = new \App\Core\View($config);

// Session
\App\Core\Auth::startSession();

// Lazy PDO getter (health never touches DB)
$getPdo = function () use ($config): \PDO {
    return \App\Core\Db::pdo($config);
};

// ---- ROUTES ----

// Health (no auth, no DB)
$app->router()->get('/health', function (): void {
    header('Content-Type: text/plain; charset=utf-8');
    echo "OK";
});

// ---------- AUTH ----------
$makeAuthController = function () use ($getPdo, $view, $appUrl): \App\Controllers\AuthController {
    $pdo = $getPdo();
    $userRepo = new \App\Repositories\UserRepository($pdo);
    return new \App\Controllers\AuthController($view, $userRepo, $appUrl);
};

// Login (public)
$app->router()->get('/login', function () use ($view): void {
    $view->render('auth/login', ['title' => 'Login']);
});

$app->router()->post('/login', function () use ($makeAuthController): void {
    $makeAuthController()->login();
});

$app->router()->post('/logout', function () use ($makeAuthController): void {
    $makeAuthController()->logout();
});

// ---------- CLIENTS ----------
$makeClientsController = function () use ($getPdo, $view, $appUrl): \App\Controllers\ClientsController {
    $pdo = $getPdo();
    $clientRepo = new \App\Repositories\ClientRepository($pdo);
    return new \App\Controllers\ClientsController($view, $clientRepo, $appUrl);
};

// Clients (protected)
$app->router()->get('/clients', function (array $params = []) use ($appUrl, $makeClientsController): void {
    \App\Core\Auth::requireLogin($appUrl);
    $makeClientsController()->index($params);
});

$app->router()->get('/clients/create', function (array $params = []) use ($appUrl, $makeClientsController): void {
    \App\Core\Auth::requireLogin($appUrl);
    $makeClientsController()->create($params);
});

$app->router()->post('/clients/create', function (array $params = []) use ($appUrl, $makeClientsController): void {
    \App\Core\Auth::requireLogin($appUrl);
    $makeClientsController()->create($params);
});

$app->router()->get('/clients/edit/{id}', function (array $params = []) use ($appUrl, $makeClientsController): void {
    \App\Core\Auth::requireLogin($appUrl);
    $makeClientsController()->edit($params);
});

$app->router()->post('/clients/edit/{id}', function (array $params = []) use ($appUrl, $makeClientsController): void {
    \App\Core\Auth::requireLogin($appUrl);
    $makeClientsController()->edit($params);
});

// ---------- INVOICES ----------
$makeInvoicesController = function () use ($getPdo, $view, $appUrl): \App\Controllers\InvoicesController {
    $pdo = $getPdo();

    $invoiceRepo = new \App\Repositories\InvoiceRepository($pdo);
    $clientRepo  = new \App\Repositories\ClientRepository($pdo);

    return new \App\Controllers\InvoicesController($view, $invoiceRepo, $clientRepo, $appUrl);
};

// Invoices (protected)
$app->router()->get('/invoices', function (array $params = []) use ($appUrl, $makeInvoicesController): void {
    \App\Core\Auth::requireLogin($appUrl);
    $makeInvoicesController()->index($params);
});

$app->router()->get('/invoices/create', function (array $params = []) use ($appUrl, $makeInvoicesController): void {
    \App\Core\Auth::requireLogin($appUrl);
    $makeInvoicesController()->create($params);
});

$app->router()->post('/invoices/create', function (array $params = []) use ($appUrl, $makeInvoicesController): void {
    \App\Core\Auth::requireLogin($appUrl);
    $makeInvoicesController()->create($params);
});

$app->router()->get('/invoices/edit/{id}', function (array $params = []) use ($appUrl, $makeInvoicesController): void {
    \App\Core\Auth::requireLogin($appUrl);
    $makeInvoicesController()->edit($params);
});

$app->router()->post('/invoices/edit/{id}', function (array $params = []) use ($appUrl, $makeInvoicesController): void {
    \App\Core\Auth::requireLogin($appUrl);
    $makeInvoicesController()->edit($params);
});

$app->router()->get('/invoices/show/{id}', function (array $params = []) use ($appUrl, $makeInvoicesController): void {
    \App\Core\Auth::requireLogin($appUrl);
    $makeInvoicesController()->show($params);
});

// DELETE invoice (protected) - koristi $makeInvoicesController (sada je definisan)
$app->router()->post('/invoices/delete/{id}', function (array $params = []) use ($appUrl, $makeInvoicesController): void {
    \App\Core\Auth::requireLogin($appUrl);
    $makeInvoicesController()->delete($params);
});

// ---------- PDF EXPORT ----------
$makePdfController = function () use ($getPdo, $config): \App\Controllers\PdfController {
    $pdo = $getPdo();
    $invoiceRepo = new \App\Repositories\InvoiceRepository($pdo);
    return new \App\Controllers\PdfController($invoiceRepo, $config);
};

// PDF Export (protected)
$app->router()->get('/invoices/pdf/{id}', function (array $params = []) use ($appUrl, $makePdfController): void {
    \App\Core\Auth::requireLogin($appUrl);
    $makePdfController()->generateInvoice($params);
});

// ---------- DASHBOARD ----------
$app->router()->get('/', function () use ($view, $appUrl): void {
    \App\Core\Auth::requireLogin($appUrl);

    $view->render('dashboard/index', [
        'title' => 'Dashboard',
    ]);
});

// Run app
$app->run();
